/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminElementTableModel;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminQueueElementTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.images.VWImageLoader;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import java.util.Vector;
import javax.swing.ImageIcon;

public abstract class VWAdminElementInQueueTableModel
extends VWAdminElementTableModel {
    protected VWQueue m_vwQueue = null;
    protected VWQueueElement m_curQueueElement = null;
    protected VWQueueQuery m_vwQueueQuery = null;
    protected String m_queueName = null;

    public VWAdminElementInQueueTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        super(resultsPane, event);
        try {
            this.m_queueName = event.getSelectedItem();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void startTheQuery() throws Exception {
        this.setQueryFlags(3 + this.m_queryFlags);
        this.setQueryFetchType(3);
        this.m_vwQueue = this.m_vwSession.getQueue(this.m_queueName);
        this.m_vwQueue.setBufferSize(this.m_maxReturned);
        this.m_vwQueueQuery = this.m_vwQueue.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
        this.getExposedFieldsDefinition();
        this.initColumnsOrder();
    }

    protected int fetchQueryCount() throws Exception {
        int count = -1;
        try {
            this.setQueryFlags(3 + this.m_queryFlags);
            this.setQueryFetchType(3);
            this.m_vwQueue = this.m_vwSession.getQueue(this.m_queueName);
            this.m_vwQueue.setBufferSize(this.m_maxReturned);
            this.m_vwQueueQuery = this.m_vwQueue.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
            count = this.m_vwQueueQuery.fetchCount();
        }
        catch (Exception ex) {
            count = -1;
            throw ex;
        }
        return count;
    }

    protected void retrieveElements() throws Exception {
        VWQueueElement curElement = null;
        int rowNum = 0;
        try {
            this.m_elementCache.removeAllElements();
            for (rowNum = 0; rowNum < this.m_maxReturned && (curElement = (VWQueueElement)this.m_vwQueueQuery.next()) != null; ++rowNum) {
                VWAdminQueueElementTableData dataField = new VWAdminQueueElementTableData(curElement, this.m_logonUser, rowNum + 1, rowNum);
                this.m_elementCache.addElement(dataField);
            }
            if (rowNum > 0) {
                ++this.m_setNum;
            }
            if (this.m_vwQueueQuery.hasNext()) {
                this.setHasNext(true);
            } else {
                this.setHasNext(false);
            }
        }
        catch (OutOfMemoryError err) {
            throw new VWException("vw.toolkit.admin.result.outOfMemoryError", "Out of memory.  Please use a smaller maximum returned set.");
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected void buildObjectCache() {
        try {
            Object curWorkObject = null;
            if (this.m_objectCache != null) {
                this.m_objectCache.removeAllElements();
            }
            if (this.m_elementCache.size() > 0) {
                for (int i = 0; i < this.m_elementCache.size(); ++i) {
                    this.m_objectCache.addElement(this.m_elementCache.elementAt(i));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void buildAvailableColumnsList() {
        VWDataField[] vwDataFields = null;
        VWQueueElement curElement = null;
        Object curWorkObject = null;
        try {
            this.m_availableColumns.removeAllElements();
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminQueueElementTableData woData = (VWAdminQueueElementTableData)this.m_objectCache.elementAt(i);
                curElement = (VWQueueElement)woData.getElement();
                vwDataFields = curElement.getDataFields();
                for (int j = 0; j < vwDataFields.length; ++j) {
                    if (this.isInVector(vwDataFields[j].getName(), this.m_availableColumns)) continue;
                    this.m_availableColumns.addElement(vwDataFields[j].getName());
                    this.m_availableFields.addElement(vwDataFields[j]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getObjectAt(int rowIndex) {
        VWAdminQueueElementTableData obj = null;
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        obj = (VWAdminQueueElementTableData)this.m_objectCache.elementAt(rowIndex);
        return obj;
    }

    protected void retrieveRowData() {
        this.retrieveRowDataForQueueElement();
    }

    protected void retrieveRowData(int rowIndex) {
        this.retrieveRowDataForQueueElement(rowIndex);
    }

    protected void getExposedFieldsDefinition() throws Exception {
        VWQueueDefinition vwQueueDefinition = null;
        vwQueueDefinition = this.m_vwQueue.fetchQueueDefinition();
        this.m_vwFieldDefinitions = vwQueueDefinition == null ? null : vwQueueDefinition.getFields();
    }

    protected Object getFieldValue(VWQueueElement obj, String colName) {
        try {
            if (obj.hasFieldName(colName)) {
                return obj.getFieldValue(colName);
            }
            return VWResource.s_emptyString;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return VWResource.s_emptyString;
        }
    }

    private void retrieveRowDataForQueueElement() {
        VWQueueElement curElement = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminQueueElementTableData woData = (VWAdminQueueElementTableData)this.m_objectCache.elementAt(i);
                curElement = (VWQueueElement)woData.getElement();
                rowData = new Vector<Object>();
                rowData.addElement(new Integer(woData.getDisplayRowIndex()));
                if (this instanceof VWAdminElementInQueueTableModel && this.isInExposedFieldDefinitions("F_Overdue", this.m_vwFieldDefinitions)) {
                    ImageIcon iconStatus = null;
                    switch (curElement.getStepDeadlineStatus()) {
                        case 1: {
                            iconStatus = VWImageLoader.createImageIcon("reminder.gif");
                            iconStatus.setDescription(VWResource.s_workItemhasReminder);
                            rowData.addElement(iconStatus);
                            break;
                        }
                        case 2: {
                            iconStatus = VWImageLoader.createImageIcon("bwoverdue.gif");
                            iconStatus.setDescription(VWResource.s_workItemIsOverdue);
                            rowData.addElement(iconStatus);
                            break;
                        }
                        case 3: {
                            iconStatus = VWImageLoader.createImageIcon("completed.gif");
                            iconStatus.setDescription(VWResource.s_workItemIsCompleted);
                            rowData.addElement(iconStatus);
                            break;
                        }
                        default: {
                            iconStatus = VWImageLoader.createImageIcon("blank.gif");
                            iconStatus.setDescription(null);
                            rowData.addElement(iconStatus);
                        }
                    }
                }
                for (int col = this.getStartIndex(); col < this.m_headers.size(); ++col) {
                    dataField = null;
                    fieldName = (String)this.m_headers.elementAt(col);
                    vwDataField = this.findDataFieldInElement(curElement, fieldName);
                    dataField = vwDataField != null ? new VWAdminFieldsTableData(vwDataField, curElement, this.m_vwSession, 1) : null;
                    rowData.addElement(dataField);
                }
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void retrieveRowDataForQueueElement(int rowIndex) {
        VWQueueElement curElement = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            VWAdminQueueElementTableData woData = (VWAdminQueueElementTableData)this.m_objectCache.elementAt(rowIndex);
            curElement = (VWQueueElement)woData.getElement();
            rowData = new Vector<Object>();
            rowData.addElement(new Integer(woData.getDisplayRowIndex()));
            if (this instanceof VWAdminElementInQueueTableModel && this.isInExposedFieldDefinitions("F_Overdue", this.m_vwFieldDefinitions)) {
                ImageIcon iconStatus = null;
                switch (curElement.getStepDeadlineStatus()) {
                    case 1: {
                        iconStatus = VWImageLoader.createImageIcon("reminder.gif");
                        iconStatus.setDescription(VWResource.s_workItemhasReminder);
                        rowData.addElement(iconStatus);
                        break;
                    }
                    case 2: {
                        iconStatus = VWImageLoader.createImageIcon("bwoverdue.gif");
                        iconStatus.setDescription(VWResource.s_workItemIsOverdue);
                        rowData.addElement(iconStatus);
                        break;
                    }
                    case 3: {
                        iconStatus = VWImageLoader.createImageIcon("completed.gif");
                        iconStatus.setDescription(VWResource.s_workItemIsCompleted);
                        rowData.addElement(iconStatus);
                        break;
                    }
                    default: {
                        iconStatus = VWImageLoader.createImageIcon("blank.gif");
                        iconStatus.setDescription(null);
                        rowData.addElement(iconStatus);
                    }
                }
            }
            for (int col = this.getStartIndex(); col < this.m_headers.size(); ++col) {
                dataField = null;
                fieldName = (String)this.m_headers.elementAt(col);
                vwDataField = this.findDataFieldInElement(curElement, fieldName);
                dataField = vwDataField != null ? new VWAdminFieldsTableData(vwDataField, curElement, this.m_vwSession, 1) : null;
                rowData.addElement(dataField);
            }
            this.m_rowCache.setElementAt(rowData, rowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

